/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.math.value;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ToDoubleFunction;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animation.state.ControllerState;
import software.bernie.geckolib.loading.math.MathValue;

public record Variable(String name, AtomicReference<ToDoubleFunction<ControllerState>> value) implements MathValue
{
    public Variable(String name, double value) {
        this(name, (ControllerState animationState) -> value);
    }

    public Variable(String name, ToDoubleFunction<ControllerState> value) {
        this(name, new AtomicReference<ToDoubleFunction<ControllerState>>(value));
    }

    @Override
    public double get(ControllerState controllerState) {
        try {
            return this.value.get().applyAsDouble(controllerState);
        }
        catch (Exception ex) {
            GeckoLibConstants.LOGGER.error("Attempted to use Molang variable for incompatible animatable type ({}). An animation json needs to be fixed", (Object)this.name);
            ex.printStackTrace();
            return 0.0;
        }
    }

    public void set(double value) {
        this.value.set(controllerState -> value);
    }

    public void set(ToDoubleFunction<ControllerState> value) {
        this.value.set(value);
    }

    @Override
    public Set<Variable> getUsedVariables() {
        return Set.of(this);
    }

    @Override
    public String toString() {
        return "variable(" + this.name + ")";
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }
}

